#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
Source: aggregat
Group by app_project & event_name.
Count events, devices
Draw stat report
"""

import os

from nile.api.v1 import (
    clusters,
    aggregators as na,
    statface as ns
)
from qb2.api.v1 import (
    extractors as qe,
    filters as qf
)

from common import (
    aggregat_table_path,
    job_root,
    magic_date_range_string,
    get_stat_client)

report = ns.StatfaceReport(
    path='Mobile_Soft_Launcher/phone/events',
    title='events',
    dimensions=[
        ns.Date('fielddate').replaceable(),
        ns.StringSelector('event').replaceable(),
        ns.StringSelector('app').replaceable(),
        ns.StringSelector('version').replaceable()
    ],
    measures=[
        ns.Number('devices').title('devices'),
        ns.Number('events').title('events')
    ]
)

client = get_stat_client()
statface_report = report.scale('daily').client(client)

output_table = '$job_root/events'
yt_token = os.environ['YT_TOKEN']
cluster = clusters \
    .Hahn() \
    .env(
        templates=dict(
            job_root=job_root,
            date=magic_date_range_string
        ))

job = cluster.job()

log = job.table(aggregat_table_path)
records = log \
    .filter(
        qf.defined('app_project', 'app_version', 'event_name', 'device_id')
    ) \
    .project(
        'device_id',
        qe.unfold_with_total('app', 'app_project', total='_total_').with_type(str),
        qe.unfold_with_total('version', 'app_version', total='_total_').with_type(str),
        qe.unfold_with_total('event', 'event_name', total='_total_').with_type(str),
        fielddate='event_date'
    ) \
    .groupby(
        'app',
        'version',
        'event',
        'fielddate',
    ) \
    .aggregate(
        events=na.count(),
        devices=na.count_distinct('device_id')) \
    .filter(
        qf.defined('event', 'app', 'version', 'fielddate', 'events', 'devices')
    ) \
    .sort('fielddate', 'devices') \
    .put(output_table) \
    .publish(statface_report)

job.run()
