#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import os

from nile.api.v1 import (
    clusters,
    aggregators as na,
    statface as ns
)
from qb2.api.v1 import (
    extractors as qe,
    filters as qf
)

from common import (
    aggregat_table_path,
    job_root,
    magic_date_range_string,
    username,
    get_stat_client)

config = {
    'event_type': 'EVENT_FIRST',
    'output_table': '$job_root/installs',
    'yt_token': os.environ['YT_TOKEN'],
}

cluster = clusters \
    .Hahn(
        pool='{}'.format(username),
        token=config['yt_token']
    ) \
    .env(
        templates=dict(
            job_root=job_root,
            date=magic_date_range_string
        ),
        yt_spec_defaults=dict(
            pool_trees=["physical"],
            tentative_pool_trees=["cloud"]
        )
    )
job = cluster.job()
log = job.table(aggregat_table_path)


records = log \
    .filter(
        qf.equals('event_type', config['event_type']),
        qf.defined('app_project')
    ) \
    .project(
        'device_id',
        qe.unfold_with_total('app', 'app_project', total='_total_'),
        fielddate='event_date',
    ) \
    .groupby('fielddate', 'app') \
    .aggregate(
        devices=na.count_distinct('device_id')) \
    .sort('fielddate', 'devices') \
    .put(config['output_table'])
job.run()


report = (
    ns.StatfaceReport()
    .path('Mobile_Soft_Launcher/phone_installs')
    .title('phone_installs')
    .scale('daily')
    .dimensions(
        ns.Date('fielddate').replaceable(),
        ns.StringSelector('app').replaceable(),
    )
    .measures(
        ns.Integer('devices').title('devices')
    )
)

client = get_stat_client()
(
    report.client(client)
    .data(records.read())
    .publish()
)
