#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import os

from nile.api.v1 import clusters, aggregators as na, extractors as ne
from qb2.api.v1 import filters as qf, extractors as qe


# Calculate Yandex.Phone activations by Launcher activations on Yandex/YNDX-000SB.


def get_city(region):  # take city if possible
    for r in region.path:
        if r.type == 6:
            return r.name
    return region.name


if __name__ == '__main__':
    output_table = '//home/advisor/reports/phone/activations'
    yt_token = os.environ['YT_TOKEN']

    cluster = clusters.yt.Hahn(pool='', token=yt_token)

    job = cluster.job()
    log = job.table(os.environ['YT_INPUT_TABLE'])  # all consistency and data recall logic if on Hitman
    records = log.qb2(
        log='metrika-mobile-log',
        fields=['device_id', 'event_date', 'region',
                qe.log_field('Manufacturer', default='unknown'),
                qe.log_field('Model', default='unknown'),
                ],
        filters=[
            qf.equals('api_key_str', '37460'),
            qf.equals('event_name', 'first_app_launch'),
            qf.equals('Manufacturer', 'Yandex'),
            qf.equals('Model', 'YNDX-000SB')
        ]).project(
        'device_id',
        fielddate='event_date',
        region=ne.custom(get_city, 'region')
    ).groupby(
        'fielddate',
        'region'
    ).aggregate(
        devices=na.count_distinct('device_id')
    )

    job.table(
        output_table
    ).concat(
        records
    ).groupby(
        'fielddate',
        'region'
    ).aggregate(
        devices=na.sum('devices')
    ).sort(
        'fielddate',
        'region'
    ).put(output_table)

    job.run()
