#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
Source: aggregat
Group by app_project & event_name.
Count events, devices
Draw stat report
"""

import os

from nile.api.v1 import clusters, aggregators as na, statface as ns
from qb2.api.v1 import extractors as qe, filters as qf

from common import (
    aggregat_table_path,
    job_root,
    magic_date_range_string,
    username,
    get_stat_client)

output_table = '$job_root/search'
yt_token = os.environ['YT_TOKEN']

cluster = clusters \
    .Hahn(pool='{}'.format(username), token=yt_token) \
    .env(templates=dict(job_root=job_root, date=magic_date_range_string))
job = cluster.job()
log = job.table(aggregat_table_path)


records = log \
    .filter(
        qf.defined('target')
    ) \
    .project(
        'device_id',
        qe.unfold_with_total('source', 'target', total='_total_'),
        fielddate='event_date'
    ) \
    .groupby(
        'fielddate',
        'source',
    ) \
    .aggregate(
        events=na.count(),
        devices=na.count_distinct('device_id', in_memory=False)) \
    .sort('fielddate', 'devices') \
    .put(output_table)
job.run()

report = (
    ns.StatfaceReport()
    .path('Mobile_Soft_Launcher/phone/search')
    .title('search')
    .scale('daily')
    .dimensions(
        ns.Date('fielddate').replaceable(),
        ns.StringSelector('source').replaceable(),
    )
    .measures(
        ns.Integer('devices').title('devices'),
        ns.Integer('events').title('events')
    )
)

client = get_stat_client()
(
    report.client(client)
    .data(records.read())
    .publish()
)
