#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import os
from collections import defaultdict

import requests
from nile.api.v1 import statface as ns

from common import (
    clid_parser,
    dates_list,
    distribution_url,
    get_stat_client)

# !!WARNING!! hardcoded collection on YaPhone clids is used in clids.txt
# source: https://st.yandex-team.ru/PHONE-2313 
clids_apps = clid_parser(fname='clids.txt')
distribution_token = os.environ['DISTRIBUTION_TOKEN']

test_report = [{u'dimensions': [{u'name': u'clid', u'value': 2322555},
                  {u'name': u'currency_id', u'value': 1}],
  u'measures': [{u'name': u'searches', u'value': 8.0},
                {u'name': u'turnover_all', u'value': None},
                {u'name': u'turnover_direct', u'value': None}]},
 {u'dimensions': [{u'name': u'clid', u'value': 2322573},
                  {u'name': u'currency_id', u'value': 1}],
  u'measures': [{u'name': u'searches', u'value': 83.0},
                {u'name': u'turnover_all', u'value': 2.938251328725564},
                {u'name': u'turnover_direct', u'value': 2.938251328725564}]},
 {u'dimensions': [{u'name': u'clid', u'value': 2322574},
                  {u'name': u'currency_id', u'value': 1}],
  u'measures': [{u'name': u'searches', u'value': 6.0},
                {u'name': u'turnover_all', u'value': None},
                {u'name': u'turnover_direct', u'value': None}]},
 {u'dimensions': [{u'name': u'clid', u'value': 2322575},
                  {u'name': u'currency_id', u'value': 1}],
  u'measures': [{u'name': u'searches', u'value': 5.0},
                {u'name': u'turnover_all', u'value': None},
                {u'name': u'turnover_direct', u'value': None}]},
 {u'dimensions': [{u'name': u'clid', u'value': 2322586},
                  {u'name': u'currency_id', u'value': 1}],
  u'measures': [{u'name': u'searches', u'value': 29.0},
                {u'name': u'turnover_all', u'value': 0.6759780877711626},
                {u'name': u'turnover_direct', u'value': 0.6759780877711626}]}]


def request_report(params):
    url = distribution_url
    params = json.dumps(params)
    headers = {
        'Authorization': 'OAuth {}'.format(distribution_token)
    }
    response = requests.post(
        url,
        data=params,
        headers=headers
    )
    response.raise_for_status()
    return response.json()


def fetch(fielddate):
    params = {
    'dimensions': ['clid'],
        'filters': [
            'AND',
                [['pack_id', '=', '7918'],
        ]],
        'measures': ['turnover_all', 'turnover_direct', 'searches'],
        'period': [fielddate, fielddate],
        'currency_convertation': '1'
    }
    return request_report(params)


def process(fielddate, clids_apps):
    # report = test_report
    data = []
    try:
        report = fetch(fielddate)
    except requests.exceptions.HTTPError:
        return data
    report = report['data']['report']
    apps = defaultdict(lambda: defaultdict(float))
    for clid in report:
        clid_value = str([
            i['value']
            for i in clid['dimensions']
            if i['name'] == 'clid'
        ][0])
        searches = [
            i['value']
            for i in clid['measures']
            if i['name'] == 'searches'
        ][0] or 0
        revenue = [
            i['value']
            for i in clid['measures']
            if i['name'] == 'turnover_all'
        ][0] or 0
        app = clids_apps.get(clid_value) or 'unknown'
        apps[app]['searches'] += searches
        apps[app]['revenue'] += revenue
    for app, measures in apps.viewitems():
        data.append(
            {
                'fielddate': fielddate,
                'searches': measures['searches'],
                'revenue': measures['revenue'],
                'app': app
            }
        )
    return data


def publish(data):
    report = (
        ns.StatfaceReport()
        .path('Mobile_Soft_Launcher/phone_search_revenue')
        .title('phone_search_revenue')
        .scale('daily')
        .dimensions(
            ns.Date('fielddate').replaceable(),
            ns.StringSelector('app').replaceable()
        )
        .measures(
            ns.Float('revenue').title('revenue'),
            ns.Integer('searches').title('searches')
        )
    )
    client = get_stat_client()
    (
        report.client(client)
        .data(data)
        .publish()
    )


def main():
    for d in dates_list:
        print d
        data = process(d, clids_apps=clids_apps)
        print data
        publish(data)
#    print fetch('2018-09-30')


if __name__ == '__main__':
    main()
