#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import os
from datetime import date

from nile.api.v1 import clusters, aggregators as na, extractors as ne, filters as nf
from nile.files import LocalFile

# Calculate Yandex.Phone activations by backend logs.

if __name__ == '__main__':
    output_table = '//home/advisor/reports/phone/server_activations'
    input_table = '//home/advisor/phone/collection'
    yt_token = os.environ['YT_TOKEN']
    common_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'common.py')
    cluster = clusters.yt.Hahn(
        token=yt_token
    ).env(packages=[LocalFile(common_path)])

    job = cluster.job()
    phones = job.table(
        input_table
    ).filter(
        nf.equals('activated', True)
    ).project(
        fielddate=ne.custom(lambda x: date.fromtimestamp(x['$date'] / 1e3).isoformat(), 'first_activation_datetime'),
    ).groupby(
        'fielddate'
    ).aggregate(
        devices=na.count()
    ).sort(
        'fielddate'
    ).put(output_table, schema={'fielddate': str, 'devices': int})
    
    job.run()
