Secrets
=======

Скрипт, скачивающий секреты разработчиков лончера из [Vault](https://yav.yandex-team.ru).

Авторизация происходит через ваш ssh ключ, так что он должен быть привязан на стаффе.
Доступ к секретам есть у скоупа "Администрирование" нашей [группы на ABC](https://abc.yandex-team.ru/services/apprec/).

Usage
-------
Можно просто запустить get_secrets.sh:
```
bash get_secrets.sh
```
Скрипт установит питоновскую библиотеку vault'a, скачает секреты с тегом "launcher_unified", положит их в файл `~/.launcher_secrets`, выставит права на файл 600 и добавит нужный `source` в `~/.bashrc`.

---

Библиотека Vault'a достаёт ssh ключ для авторизации из ssh-agent'а.
Это значит, что если вы не прокидывали ключ на машинку через агента
и у вас не установлен ключ в агента сейчас, скрипт может выдать соответствующую ошибку.
Чтобы её пофиксить нужно сделать
```
eval $(ssh-agent -s)
ssh-add
```  
и снова запустить скрипт

---

Для использования питоновского скрипта надо сначала установить библиотеку [api vault'а](https://vault-api.passport.yandex.net/docs/#cli):
```
pip install yandex-passport-vault-client -i https://pypi.yandex-team.ru/simple
```

После установки можно запускать так:
```
python get_secrets.py [-h] [-o OUTPUT] [--bashrc] [--nochmode]
```

Для запуска для python 2 через скрипт:
```
./get_secrets.sh py2
```

Имеющиеся опции:
 * `-o OUTPUT`   — файл, в который сохранять секреты (по дефолту выводит в stdout)
 * `--bashrc, -b` — добавить соответствующую строчку `source` в `~/.bashrc`
 * `--nochmode, -c` — не выставлять права 600 на файл (по дефолту выставляет)

Добавление секретов
-------
Чтобы добавить новый секрет нужно создать его в [Vault](https://yav.yandex-team.ru), добавить ему тег "launcher_unified" и дать права OWNER скоупу "Администрирование" нашей [группы на ABC](https://abc.yandex-team.ru/services/apprec/) (ID 1994).
В ключе нужно указать имя переменной окружения, а в значении значение секрета.
