package main

import (
	"net/http"
	"strings"
)

type YaHeaders struct {
	tags           string
	yaUUIDs        []string
	userAgentParts []string
}

var CarHeaders = &YaHeaders{
	tags: "X-Updr-Tags",
	// Hardcoded Automotive UUIDs.
	// TODO: remove it or add UUIDs for clients with empty User-Agent only.
	yaUUIDs: []string{
		"2516d3cff3ff5de96c2f69d4497063d6",
		"31951dfe9b113fda2c7c6897467a048f",
	},
	userAgentParts: []string{
		"tw captur-astar-yacs",
		"ecarx",
		"korea",
		"rockchip d200",
		"alps 8227l_demo",
		"faurecia-coagent",
		"sp9853i_1h10_vmm",
		"automotive-updater",
	},
}

func (h YaHeaders) in(reqHeaders *http.Header) bool {
	if reqHeaders.Get(h.tags) != "" {
		return true
	}

	reqYaUUID := strings.ToLower(reqHeaders.Get("X-YaUuid"))
	for _, yaUUID := range h.yaUUIDs {
		if yaUUID == reqYaUUID {
			return true
		}
	}

	reqUa := reqHeaders.Get("User-Agent")
	if reqUa == "" {
		return false
	} else {
		reqUa = strings.ToLower(reqUa)
	}

	for _, uaPart := range h.userAgentParts {
		inside := strings.Contains(reqUa, uaPart)
		if inside {
			return true
		}
	}

	return false
}
