package main

import (
	"fmt"
	"net/http"
	"net/url"
	"strings"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/yaphone/updater-gateway/internal/config"
	"a.yandex-team.ru/yaphone/updater-gateway/internal/logging"
)

var logger = logging.GetLogger()

func makeRedirectURL(url *url.URL, client *config.Client) string {
	current := *config.CurrentClient
	if client.Host != "" {
		url.Scheme = "https"
		url.Host = client.Host
	}
	url.Path = strings.Replace(url.Path, current.BaseURI, client.BaseURI, 1)
	return url.String()
}

func RedirectHandler(w http.ResponseWriter, req *http.Request) {
	if CarHeaders.in(&req.Header) {
		redirectURL := makeRedirectURL(req.URL, config.AutoClient)
		logger.Infof("Redirecting to automotive server " + redirectURL)
		http.Redirect(w, req, redirectURL, http.StatusMovedPermanently)
	} else {
		redirectURL := makeRedirectURL(req.URL, config.NewClient)
		logger.Infof("Redirecting to updater server " + redirectURL)
		http.Redirect(w, req, redirectURL, http.StatusFound)
	}
}

func main() {
	router := chi.NewRouter()
	router.Get("/api/v1/{path:.*}", RedirectHandler)

	err := http.ListenAndServe(fmt.Sprintf(":%d", config.CurrentClient.Port), router)
	logger.Fatalf("Error during ListenAndServe: %v", err)
}
