package main

import (
	"net/http"
	"testing"

	testify "github.com/stretchr/testify/assert"
)

var hardcodedAutomotiveUUID = []string{
	"2516d3cff3ff5de96c2f69d4497063d6",
	"31951dfe9b113fda2c7c6897467a048f",
}

var knownYaPhoneUUID = []string{"048203cec91dd9c0d43a0bb332eb322c"}

var visibilityConditions = []string{"autolauncher,release,carsharing", "RU"}

var carUserAgents = []string{
	"com.yandex.launcher.updaterapp/1.2.6 (faurecia-Coagent t3-demo-yaAM-mts; Android 6.0.1)",
	"com.yandex.launcher.updaterapp/1.2.6 (faurecia-Coagent t3-demo-yaAM; Android 6.0.1)",
	"com.yandex.launcher.updaterapp/1.2.6 (faurecia-Coagent t3-duster-yaAM-mts; Android 6.0.1)",
	"com.yandex.launcher.updaterapp/1.2.6 (faurecia-Coagent t3-duster-yaAM; Android 6.0.1)",
	"com.yandex.launcher.updaterapp/1.2.6 (faurecia-Coagent t3-generic-ya; Android 6.0.1)",
	"com.yandex.launcher.updaterapp/1.2.10 (alps 8227L_demo; Android 8.1Go)",
	"com.yandex.launcher.updaterapp/1.2.6 (KOREA t3-polo-yaAM; Android 7.1.2)",
	"com.yandex.launcher.updaterapp/1.2.6 (KOREA t3-solaris-yaAM; Android 7.1.2)",
	"com.yandex.launcher.updaterapp/1.2.6 (tw Captur-astar-yaCS; Android 4.4.2)",
	"automotive-updater",
}

var updaterUserAgents = []string{
	"com.yandex.launcher.updaterapp/ (DEXP B255; Android 7.0)",
	"com.yandex.launcher.updaterapp/1.6.1009284 (Droi BQ-5041L Shark Pro; Android 9)",
	"com.yandex.launcher.updaterapp/1.0.510 (Fly FS510; Android 6.0)",
	"com.yandex.launcher.updaterapp/ (Fly FS514; Android 6.0.0.go)",
	"com.yandex.launcher.updaterapp/ (Fly FS508; Android 6.0)",
	"com.yandex.launcher.updaterapp/1.0.510 (JazzX JS7 PRO; Android 6.0)",
	"com.yandex.launcher.updaterapp/1.0.510 (L540 L540; Android 6.0)",
	"com.yandex.launcher.updaterapp/1.0.510 (POSH L520; Android 6.0)",
	"com.yandex.launcher.updaterapp/1.0.510 (Posh E550; Android 5.1)",
	"com.yandex.launcher.updaterapp/1.1.575 (Wileyfox Wileyfox Spark X; Android 7.0)",
	"com.yandex.launcher.updaterapp/1.1.575 (ZTE ZTE BLADE A210; Android 6.0)",
	"com.yandex.launcher.updaterapp/1.2.1 (Allwinner t3; Android 4.4.2)",
}

type assert struct{ *testify.Assertions }

func (a *assert) HeadersDetected(key string, values []string) {
	header := http.Header{}
	for _, ua := range values {
		header.Set(key, ua)
		a.True(CarHeaders.in(&header))
	}
}

func (a *assert) HeadersNotDetected(key string, values []string) {
	header := http.Header{}
	for _, ua := range values {
		header.Set(key, ua)
		a.False(CarHeaders.in(&header))
	}
}

func TestCarHeaders_Detected(t *testing.T) {
	assert := assert{testify.New(t)}
	assert.NotNil(CarHeaders)
	assert.HeadersDetected("User-Agent", carUserAgents)
	assert.HeadersDetected("X-Updr-Tags", visibilityConditions)
	assert.HeadersDetected("X-YaUuid", hardcodedAutomotiveUUID)
}

func TestUpdaterHeaders_NotDetected(t *testing.T) {
	assert := assert{testify.New(t)}
	assert.HeadersNotDetected("User-Agent", updaterUserAgents)
	assert.HeadersNotDetected("X-YaUuid", knownYaPhoneUUID)
}
