package config

import (
	"os"
	"strconv"

	"a.yandex-team.ru/yaphone/gotifier/pkg/yenv"
)

type Client struct {
	Host    string
	Port    int
	BaseURI string
}

func getIntEnv(name string, default_ int64) int64 {
	stringValue := os.Getenv(name)
	intValue, err := strconv.ParseInt(stringValue, 10, 64)
	if err != nil {
		intValue = default_
	}
	return intValue
}

var CurrentClient = &Client{
	BaseURI: "/api/v1/",
	Port: yenv.ChooseKeyByType(map[string]interface{}{
		"production":  int(getIntEnv("LISTEN_PORT", 80)),
		"development": 8060,
	}, true).(int),
}

var AutoClient = &Client{
	Host:    os.Getenv("AUTOMOTIVE_HOST"),
	BaseURI: "/mobileupdater/1.x/",
}

var NewClient = &Client{
	BaseURI: "/api/v2/",
}
