package logging

import (
	"os"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/yaphone/gotifier/pkg/yenv"
)

var logger *zap.Logger

func GetLogger() *zap.Logger {
	if logger == nil {
		logger = InitLogger()
	}
	return logger
}

func CreateLogger(level log.Level) (*zap.Logger, error) {
	if os.Getenv("QLOUD_ENVIRONMENT") == "" {
		return zap.New(zap.ConsoleConfig(level))
	} else {
		return zap.NewQloudLogger(level)
	}
}

func InitLogger() *zap.Logger {
	level := yenv.ChooseKeyByType(map[string]interface{}{
		"production": log.InfoLevel,
		"testing":    log.DebugLevel,
	}, true).(log.Level)

	logger, err := CreateLogger(level)

	if err != nil {
		panic(err)
	}

	logger.Info("logger initialized", log.String("level", level.String()))
	return logger
}
