import os
import requests
from fabric.api import *

QLOUD_API_TEMPLATE = 'https://platform.yandex-team.ru/api/v1/environment/overview/{environment}'
QLOUD_TOKEN = os.environ.get('QLOUD_OAUTH_TOKEN')

qloud_components_roles = {
    'testing': ('yandex-phone.updater.testing', ['updater']),
    'stable': ('yandex-phone.updater.production', ['updater']),
}


def get_hosts_from_qloud(role):
    environment, components = qloud_components_roles[role]
    headers = {"Authorization": "OAuth %s" % QLOUD_TOKEN}
    url = QLOUD_API_TEMPLATE.format(environment=environment)
    response = requests.get(url=url, headers=headers)
    try:
        environment = response.json()
    except Exception as e:
        print 'error: cannot get hosts: %s' % e
        print 'response: %s (%s)' % (response.content, response.status_code)
        raise

    return [
        instance['host']
        for component in components
        for instance in environment['components'][component]['instances'].itervalues()
    ]


# Define roles
env.roledefs = {role: get_hosts_from_qloud(role) for role in qloud_components_roles}

env.roles = env.roles or ['testing']


def continuous(*args, **kwargs):
    try:
        run(*args, **kwargs)
    except KeyboardInterrupt:
        pass


@task
@runs_once
def testhosts():
    import json

    for role in env.roles:
        hosts = sorted(get_hosts_from_qloud(role))
        try:
            shosts = json.dumps(hosts, indent=2)
        except Exception as e:
            print 'json.dumps error: %s' % e
            shosts = str(hosts)

        print 'role "%s" hosts(%d): %s' % (role, len(hosts), shosts)


@task
@parallel
def log():
    continuous('tail -f /run/qloud/app.stderr || true')


@task
@parallel
def cmd(c):
    run(c)
