import os
from distutils.core import setup

from django.conf import settings
from django.core.management import execute_from_command_line
from setuptools import find_packages
from setuptools.command.test import test


def get_version():
    with open('./debian/changelog') as f:
        first_line = f.readline().strip()
        return first_line.partition('(')[2].partition(')')[0]


class DjangoTests(test):
    def run(self):
        os.environ["DJANGO_SETTINGS_MODULE"] = "updater.tests.settings"
        execute_from_command_line(['manage.py', 'test', 'updater.tests'])


setup(
    name='django-android-apps-updater',
    version=get_version(),
    url='https://github.yandex-team.ru/mobserver/updater',
    author='Aleksandr Igoshkin',
    author_email='igoshkin@yandex-team.ru',
    packages=find_packages(),
    cmdclass={
        'test': DjangoTests,
    },
)
