import json
from collections import namedtuple

localization_values = {
    'clients_mapping': json.dumps(
        {
            "com.yandex.launcher.updaterapp": [
                {
                    "conditions": {
                        "X_UPDR_TAGS": False
                    },
                    "value": "launcher."
                },
                {
                    "conditions": {
                        "X_UPDR_TAGS": True
                    },
                    "value": "auto."
                }
            ],
            "Mozilla": {
                "value": "browser."
            }
        }
    ),
    'tracked_builds': json.dumps(
        [
            {
                "beta_name": "launcher_updater",
                "package_name": "com.yandex.launcher.updaterapp",
                "branch": "dev"
            },
            {
                "beta_name": "launcher",
                "package_name": "com.yandex.launcher",
                "branch": "dev"
            },
            {
                "beta_name": "browser",
                "package_name": "com.yandex.browser",
                "branch": "arm-classic-stable",
                "visibility_conditions": [
                    "arm",
                    "classic",
                    "stable"
                ]
            },
            {
                "beta_name": "autoserv_redpower",
                "package_name": "ru.yandex.yap.hal.services",
                "branch": "testing",
                "visibility_conditions": [
                    "autolauncher",
                    "testing",
                    "carsharing",
                    "astar",
                    "RU",
                    "TR"
                ]
            }
        ]
    ),
    'launcher.tracked_builds': json.dumps(
        [
            {
                "beta_name": "launcher_updater",
                "package_name": "com.yandex.launcher.updaterapp",
                "branch": "dev"
            },
            {
                "beta_name": "launcher",
                "package_name": "com.yandex.launcher",
                "branch": "dev"
            }
        ]
    ),
    'browser.tracked_builds': json.dumps(
        [
            {
                "beta_name": "browser",
                "package_name": "com.yandex.browser",
                "branch": "arm-classic-stable",
                "visibility_conditions": [
                    "arm",
                    "classic",
                    "stable"
                ]
            }
        ]
    ),
    'auto.tracked_builds': json.dumps(
        [
            {
                "beta_name": "autoserv_redpower",
                "package_name": "ru.yandex.yap.hal.services",
                "branch": "testing",
                "visibility_conditions": [
                    "autolauncher",
                    "testing",
                    "carsharing",
                    "astar",
                    "RU",
                    "TR"
                ]
            }
        ]
    ),
    'empty_list.tracked_builds': '[]',
    'empty.tracked_builds': '',
    'client.test': 'abc'
}

LocalizationItem = namedtuple('LocalizationItem', ['name', 'value'])
LocalizationUser = namedtuple('LocalizationUser', ['language'])

class UserSpecificConfig(object):
    def __init__(self, *args, **kwargs):
        self.user = LocalizationUser('ru')

    # noinspection PyUnusedLocal
    @staticmethod
    def get_value(param_name, default_value=None, log_missing=True):
        return localization_values.get(param_name, default_value)

    # noinspection PyMethodMayBeStatic
    def translate(self, _):
        return 'abc'

    # noinspection PyMethodMayBeStatic
    def get_all_enabled_items(self):
        return [LocalizationItem(name=name, value=value) for name, value in localization_values.iteritems()]
