# coding: utf-8

from collections import namedtuple

StoredToReturning = namedtuple(
    'StoredToReturning',
    [
        'version',
        'version_code',
        'size',
        'branch'
    ]
)

Branch = namedtuple(
    'Branch',
    [
        'app',
        'name'
    ]
)

App = namedtuple(
    'App',
    [
        'name',
        'russian1'
    ]
)


class AppFile(object):
    filename = 'some.apk'
    stored_to_returning = StoredToReturning(
        version='2.0.6',
        version_code=2000543,
        size=16 * 1024 * 1024,
        branch=Branch(
            app=App(name='Some app', russian1=u'Приложение'),
            name='master')
    )

class FirmwareFile(object):
    filename = "yphone_rom-uwp.zip"
    stored_to_returning = StoredToReturning(version='0.0.2', version_code=2, size=689066235, branch='dev_test')
