from django.db import models


class Apps(models.Model):
    name = models.CharField(unique=True, db_column='app_name', max_length=20)
    filename_prefix = models.CharField(unique=True, max_length=20)
    russian1 = models.CharField(max_length=40)

    class Meta:
        managed = False
        db_table = 'apps'


class Branches(models.Model):
    app = models.ForeignKey(Apps, db_column='app')
    name = models.CharField(max_length=52, blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'branches'


class StoredToReturning(models.Model):
    branch = models.ForeignKey(Branches, db_column='branch')
    version = models.CharField(max_length=64, blank=True, null=True)
    version_code = models.IntegerField(blank=True, null=True)
    size = models.BigIntegerField()

    class Meta:
        managed = False
        db_table = 'stored_to_returning'


class AppFile(models.Model):
    stored_to_returning = models.ForeignKey(StoredToReturning, db_column='stored_to_returning')
    filename = models.CharField(max_length=255)

    class Meta:
        managed = False
        db_table = 'app_files'
