from rest_framework import serializers

class UpdateTypes:
    LOCAL = 'yandex'
    GOOGLE_PLAY = 'google_play'
    FIRMWARE = 'firmware'

# noinspection PyAbstractClass
class UpdateSerializer(serializers.Serializer):
    package_name = serializers.CharField()
    version_name = serializers.CharField()
    version_code = serializers.IntegerField()
    type = serializers.CharField()


# noinspection PyAbstractClass
class LocalUpdateSerializer(UpdateSerializer):
    app_name = serializers.CharField()
    download_url = serializers.URLField()
    size = serializers.IntegerField()


class GpUpdateSerializer(UpdateSerializer):
    title = serializers.CharField()
