import logging
import os

import yenv

from version import VERSION

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'n1iefcs7z0)5u4j&%%yzd7^4q&81c73-+&5j&hi%vch5l!6x54'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = yenv.choose_key_by_type({
    'production': False,
    'development': True,
}, fallback=True)

ALLOWED_HOSTS = ['*']

# Application definition

INSTALLED_APPS = (
    'django.contrib.contenttypes',
    'django.contrib.auth',
    'rest_framework',
    'memoize',
    'updater'
)

MIDDLEWARE_CLASSES = (
    'updater.middleware.FixEmptyHostMiddleWare',
    'django.middleware.common.CommonMiddleware',
    'updater.middleware.HttpHeadersLoggingMiddleware',
)

USE_EXCEPTION_MIDDLEWARE = yenv.choose_key_by_type({
    'production': True,
    'development': False,
}, fallback=True)

if USE_EXCEPTION_MIDDLEWARE:
    MIDDLEWARE_CLASSES = ('updater.middleware.ExceptionLoggingMiddleware',) + MIDDLEWARE_CLASSES

ROOT_URLCONF = 'updater.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
            ],
        },
    },
]

WSGI_APPLICATION = 'updater.wsgi.application'

# Database
# https://docs.djangoproject.com/en/1.8/ref/settings/#databases

MY_SQL_USER = os.environ.get('BETA_MYSQL_USER')
MYSQL_PASSWORD = os.environ.get('BETA_MYSQL_PASSWORD')
HOST_MASTER = 'db02.maps.yandex.ru'
HOST_RO = 'db02ro.maps.yandex.net'

DATABASES = {
    'default': {},
    'updater_db': {
        'ENGINE': 'django.db.backends.mysql',
        'USER': MY_SQL_USER,
        'PASSWORD': MYSQL_PASSWORD,
        'HOST': HOST_RO,
        'NAME': yenv.choose_key_by_type({
            'testing': 'phonedetectbetadb',
            'production': 'phonedetectdb'
        }, fallback=True)
    },
    'setup_wizard_db': {
        'ENGINE': 'django.db.backends.mysql',
        'USER': MY_SQL_USER,
        'PASSWORD': MYSQL_PASSWORD,
        'HOST': HOST_RO,
        'NAME': yenv.choose_key_by_type({
            'production': 'phonedetectdb'
        }, fallback=True)
    }
}

# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/

LANGUAGE_CODE = 'en-us'
TIME_ZONE = None
USE_TZ = True

SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTO', 'https')

SENTRY_URL_TEST = 'https://b02443ff25ce46168acdaf42d29ce238' \
                  '@sentry-test-proxy.t.yandex.net/508?verify_ssl=0'
SENTRY_URL_PROD = 'https://ef4f623f80ff4fdfb57cc670ac9f5a65' \
                  '@sentry.iddqd.yandex.net/847?verify_ssl=0'

SENTRY_DSN = yenv.choose_key_by_type({
    'testing': SENTRY_URL_TEST,
    'production': SENTRY_URL_PROD,
    'stress': '',
    'development': '',
}, fallback=True)

RAVEN_CONFIG = {
    'dsn': SENTRY_DSN,
    'string_max_length': 8192,
    'list_max_length': 256,
    'release': VERSION,
    'environment': yenv.type,
}

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            'format': '[%(asctime)s] [%(process)d] [%(levelname)s] [%(name)s] %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'class': 'logging.Formatter',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter'
        }
    },
    'handlers': {
        'qloud': {
            'class': 'logging.StreamHandler',
            'formatter': 'json'
        },
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'default',
        },
        'sentry': {
            'level': logging.ERROR,
            'class': 'raven.contrib.django.raven_compat.handlers.SentryHandler',
        },
    },
    'loggers': {
        '': {
            'level': yenv.choose_key_by_type({
                'production': logging.INFO,
                'testing': logging.DEBUG,
            }, fallback=True),
            'handlers': yenv.choose_key_by_type({
                'production': ['qloud', 'sentry'],
                'stress': ['qloud'],
                'development': ['console'],
            }, fallback=True),
            'propagate': True,
        },
    },
}

CACHES = {
    'default': {
        'BACKEND': 'redis_cache.RedisCache',
        'LOCATION': 'localhost:6379',
        'TIMEOUT': 86400,  # 1 day
        'OPTIONS': {
            'SERIALIZER_CLASS': 'redis_cache.serializers.JSONSerializer',
        }
    },
}

TEST_RUNNER = 'updater.tests.ExistingDBTestRunner'

REST_FRAMEWORK = {
    'DEFAULT_RENDERER_CLASSES': (
        'rest_framework.renderers.JSONRenderer',
    ),
    'DEFAULT_PARSER_CLASSES': (
        'rest_framework.parsers.JSONParser',
    ),
}

LOCALIZATION_PROJECT = 'updater'
LOCALIZATION_TRANSLATIONS_PROJECT = 'launcher_translations'

APP_TO_LOCALIZATION_KEY = {
    'launcher': 'general_app_name',
    'launcher_updater': 'updater_app_name',
    'yandexservices': 'services_app_name',
}

TRACKED_BUILDS = []

APK_DOWNLOAD_SECRET_KEY = os.environ.get('APK_DOWNLOAD_SECRET_KEY')

APK_DOWNLOAD_URL_TEMPLATE = yenv.choose_key_by_type({
    'testing': 'https://beta.m.soft.yandex.ru/download/{app_name}/{branch}/{file_name}?time={time}&signature={sign}',
    'production': 'https://m.soft.yandex.ru/download/{app_name}/{branch}/{file_name}'
}, fallback=True)

ALEKSANDRIA_DOWNLOAD_URL_TEMPLATE = yenv.choose_key_by_type({
    'production': 'https://m.soft.yandex.ru/download/{app_name}/{branch}/{file_name}'
}, fallback=True)

APP_INFO_URL = yenv.choose_key_by_type({
    'production': 'http://saas-searchproxy.yandex.net:17000/',
    'stress': 'http://saas-searchproxy-prestable.yandex.net:17000/',
}, fallback=True)

MONGO_HOSTS = yenv.choose_key_by_type({
    'production': [
        'vla-8h8moxom5mcqvhxq.db.yandex.net:27018',
        'sas-350atkewrtqdqznw.db.yandex.net:27018',
        'iva-g4rokm43mg6rjizc.db.yandex.net:27018',
    ],
    'testing': [
        'sas-m6ed1vwh01lxm0td.db.yandex.net:27018',
        'vla-5xqt1wmnesk3vqto.db.yandex.net:27018',
    ],
}, fallback=True)

MONGO_USER = os.environ.get('MONGO_USER')
MONGO_PASSWORD = os.environ.get('MONGO_PASSWORD')
MONGO_DB_NAME = 'advisor_db'

mongodb_uri_template = 'mongodb://{user}:{password}@{hosts}/{database}'

MONGO_URI = mongodb_uri_template.format(
    user=MONGO_USER,
    password=MONGO_PASSWORD,
    hosts=','.join(MONGO_HOSTS),
    database=MONGO_DB_NAME,
)

LOCALIZATION_CONFIG_PATH = yenv.choose_key_by_type({
    'development': '/etc/yandex/mobile/shared_localizations/default.cfg',
    'production': '/etc/localization.cfg',
}, fallback=True)

LOCALIZATION_MONGO_DBNAME = 'localizations_db'

LOCALIZATION_MONGO_URI = mongodb_uri_template.format(
    user=MONGO_USER,
    password=MONGO_PASSWORD,
    hosts=','.join(MONGO_HOSTS),
    database=LOCALIZATION_MONGO_DBNAME,
)

YT_TOKEN = os.environ.get('YT_TOKEN')
YT_PROXIES = os.environ.get('YT_PROXIES', 'hahn.yt.yandex.net,arnold.yt.yandex.net').split(',')
YT_APPS_DYNAMIC_TABLE = '//home/advisor/apps/dynamic'
