import os
import time
from hashlib import sha256

from django.conf import settings


def sign_download(app, file_name, ts):
    return sha256(app + os.path.splitext(file_name)[0] + str(ts) + settings.APK_DOWNLOAD_SECRET_KEY).hexdigest()


# reverse engineering of https://github.yandex-team.ru/mobserver/soft-download-pages-admin/blob/
#                                                                   dev/m_yandex_export/source/website/download.py#L41
def get_download_url(app_name, branch, filename):
    ts = int(time.time())

    return settings.APK_DOWNLOAD_URL_TEMPLATE.format(
        app_name=app_name,
        branch=branch,
        file_name=filename,
        time=ts,
        sign=sign_download(app_name, filename, ts)
    )


def get_local_promo_download_url(app_name, branch, filename):
    return settings.ALEKSANDRIA_DOWNLOAD_URL_TEMPLATE.format(
        app_name=app_name,
        branch=branch,
        file_name=filename
    )
