import os.path
from django.conf import settings


from updater.mongo import check_mock, UpdateSubscriptions, YandexDistributedApp


def make_fixtures_path(fixture_file):
    return os.path.join(settings.BASE_DIR, settings.FIXTURES_PATH, fixture_file)


class DatabaseFixturesMixin(object):
    def load_fixtures(self):
        check_mock()

        promo_filename = make_fixtures_path('updater_promo.json')
        with open(promo_filename) as promo_file:
            promo_model = UpdateSubscriptions.from_json(promo_file.read())
            promo_model.save(force_insert=True)

        for app_name in ['com.yandex.launcher', 'com.yandex.launcher.updaterapp', 'com.computer.desktop.ui.launcher']:
            YandexDistributedApp(package_name=app_name).save(force_insert=True)

    def cleanup_fixtures(self):
        check_mock()

        UpdateSubscriptions.drop_collection()
        YandexDistributedApp.drop_collection()
