# coding=utf-8
import json

from django.test import SimpleTestCase
from django.test.client import Client

from updater.mongo import YandexDistributedApp, UpdateSubscriptions

BETA_APPS = ['com.legionlabs.p2p.open', 'com.yandex.launcher', 'com.computer.desktop.ui.launcher']
TEST_PACKAGE_NAME = BETA_APPS[0]

DEVICE_ID = "2" * 32


class SubscribeTest(SimpleTestCase):
    def setUp(self):
        for item in BETA_APPS:
            YandexDistributedApp(package_name=item).save(force_insert=True)
        self.client = Client()

    def tearDown(self):
        UpdateSubscriptions.objects(device_id=DEVICE_ID).delete()
        YandexDistributedApp.objects.delete()

    def post(self, method, package_name=TEST_PACKAGE_NAME, device_id=DEVICE_ID):
        data = json.dumps({'package_name': package_name, 'device_id': device_id})
        return self.client.post('/api/v1/%s/' % method, data=data, content_type='application/json')

    def test_sub_unsub_sequence(self):
        n1 = UpdateSubscriptions.objects(device_id=DEVICE_ID).count()
        self.assertEqual(self.post('subscribe').status_code, 200)

        n2 = UpdateSubscriptions.objects(device_id=DEVICE_ID).count()
        self.assertEqual(n1 + 1, n2)

        self.assertEqual(self.post('subscribe').status_code, 200)
        n3 = UpdateSubscriptions.objects(device_id=DEVICE_ID).count()
        self.assertEqual(n2, n3)

        self.assertEqual(self.post('unsubscribe').status_code, 200)
        n4 = UpdateSubscriptions.objects(device_id=DEVICE_ID).count()
        self.assertEqual(n4, n1)

        self.assertEqual(self.post('unsubscribe').status_code, 404)

    def test_unknown_app(self):
        self.assertEqual(self.post('subscribe', package_name='never.exists.package').status_code, 406)
