"""
WSGI config for updater project.

It exposes the WSGI callable as a module-level variable named ``application``.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/howto/deployment/wsgi/
"""

import os

from django.core.wsgi import get_wsgi_application

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "updater.settings")

application = get_wsgi_application()

from localization import init_cache
from django.conf import settings
init_cache(
    db_name=settings.LOCALIZATION_MONGO_DBNAME,
    mongo_uri=settings.LOCALIZATION_MONGO_URI,
    projects=[settings.LOCALIZATION_PROJECT, settings.LOCALIZATION_TRANSLATIONS_PROJECT]
)
