from string import printable


def make_http_header(header):
    return 'HTTP_%s' % header.upper().replace('-', '_').replace('.', '_')


def drop_non_printable(string):
    return ''.join(filter(lambda x: x in printable, string))


def get_http_header(request, header):
    header_string = request.META.get(make_http_header(header))
    if header_string is not None:
        return drop_non_printable(header_string)


def get_user_ip(request):
    x_forwarded_for_y = get_http_header(request, 'X_FORWARDED_FOR_Y')
    if x_forwarded_for_y:
        return x_forwarded_for_y.split(',')[0].strip()
    else:
        return request.META.get('REMOTE_ADDR')
