from six.moves import zip_longest


def convert_if_int(s):
    if s.isdecimal():
        return int(s)
    return s


class ParsedVersion(object):
    FILLVALUE = 0

    def __init__(self, version):
        if not version:
            self.version = None
        else:
            self.version = [convert_if_int(s) for s in version.replace('.', '-').split('-')]

    def __le__(self, other):
        # None works as +-infinity (less than any version and more than any version)
        if self.version is None or other.version is None:
            return True
        # (c) @igoshkin -- alpha < any number
        for left, right in zip_longest(self.version, other.version, fillvalue=self.FILLVALUE):
            left_int, right_int = isinstance(left, int), isinstance(right, int)
            if left_int == right_int and left == right:
                continue
            if left_int:
                return right_int and left < right
            else:
                return right_int or left < right
        return True

    def __gt__(self, other):
        return not (self <= other)

    def __ge__(self, other):
        return other <= self

    def __lt__(self, other):
        return not (other <= self)

    def __eq__(self, other):
        return self.version == other.version

    def __repr__(self):
        return '.'.join(map(str, self.version))
