const supportForm = 'https://forms.yandex-team.ru/surveys/72507/';
const appSourceURL = 'https://raw.github.yandex-team.ru/kirilleremin/yawe/master/extension/application.js';

function openSupportLink() {
    chrome.tabs.create({ url: supportForm });
}

function getErrorMessage(error) {
    const title = `
        <div 
            style="font-weight: bold; 
            font-size: 15px; 
            text-align: center"
        >
            Не удалось загрузить расширение
        </div>
    `;

    const errorText = `
        <div 
            style="min-width: 300px; 
            max-width: 300px; 
            margin-top: 10px; 
            color: gray; 
            text-align: center;"
        >
            ${String(error)}
        </div>
    `;

    const link = `
        <a id="supportLink"
            href="${supportForm}" 
            style="border: 1px solid rgb(247, 43, 53); 
            color: rgba(0, 0, 0, 0.9);
            display: block;
            padding: 10px;
            margin: 10px 0;
            text-decoration: none;
            text-align: center;
            font-size: 13px;"
        >
            Написать в поддержку
        </a>
    `;

    return `${title}${errorText}${link}`;
}

async function init() {
    try {
        const response = await fetch(appSourceURL);
        const appSource = await response.text();

        eval(appSource);
        console.log('PRODUCTION!');
    } catch (error) {
        document.querySelector('#root').innerHTML = getErrorMessage(error);
        document.querySelector('#supportLink').addEventListener('click', openSupportLink);
    }
}

init();
