const fs = require('fs');

const packageJSONPath = __dirname + '/../package.json';
const manifestPath = __dirname + '/../extension/manifest.json';

// "4" or "4.0.0"
const MAGOR_PATTERN = /^(\d+)/;

const toVersion = (versionString) => Number(MAGOR_PATTERN.exec(versionString)[0]);

function updateVersion(path) {
    const removeBom = text => text.replace(/^\uFEFF/, '');

    const json = JSON.parse(removeBom(fs.readFileSync(path, 'utf8')));

    const version = json.version.replace(MAGOR_PATTERN, (v) => String(Number(v) + 1));

    json.version = version;
    fs.writeFileSync(path, JSON.stringify(json, null, '  '), 'utf8');

    return toVersion(version);
}

const packageJsonVersion = updateVersion(packageJSONPath);
const manifestVersion = updateVersion(manifestPath);

if (packageJsonVersion !== manifestVersion) {
    console.error(`VERSIONS ARE NOT EQUAL! package.json version = "${packageJsonVersion}", manifest = "${manifestVersion}"`);
}
