import React, { useState } from 'react';

import { AccountHeader } from './parts/AccountHeader';
import { AccountData } from './parts/AccountData';
import { AccountAuthButton } from './parts/AccountAuthButton';
import { AccountShareButton } from './parts/AccountShareButton';
import { AddToFavoritesButton } from './parts/AddToFavoritesButton';

import styles from './Account.pcss';

export const Account = props => {
    const { account } = props;

    const [accountData, setAccountData] = useState(account);

    return (
        <div className={styles.root}>
            <AccountHeader account={accountData} />
            <AccountData account={accountData} setAccountData={setAccountData} />
            <AccountAuthButton account={accountData} />
            <AccountShareButton account={accountData} />
            <AddToFavoritesButton account={accountData} setAccountData={setAccountData} />
        </div>
    );
};
