import React from 'react';

import { BorderType } from 'src/components/Button';
import { AuthorizationButton, AuthorizationButtonType } from 'src/components/AuthorizationButton';

import styles from './AccountAuthButton.pcss';

export const AccountAuthButton = props => {
    const { account } = props;

    return (
        <div className={styles.root}>
            <div className={styles.requestAuthButton}>
                <AuthorizationButton borderType={BorderType.WITHOUT_TOP_RADIUS} account={account} />
            </div>

            <div title="Перейти на страницу паспорта" className={styles.passportAuthButton}>
                <AuthorizationButton
                    type={AuthorizationButtonType.LINK}
                    borderType={BorderType.WITHOUT_BORDERS}
                    account={account}
                >
                    <div className={styles.passportImage} />
                </AuthorizationButton>
            </div>
        </div>
    );
};
