import React, { useCallback, useState } from 'react';

import { Text, TextSize } from 'src/components/Text';

import styles from './AccountData.pcss';
import { Button, BorderType } from 'src/components/Button';
import { AccountNameEditor } from 'src/components/Account/parts/AccountNameEditor';
import { defaultAccountName } from 'src/components/Account/config';
import { logInfo } from 'src/logger';

export const AccountData = props => {
    const { account, setAccountData } = props;
    const { name, login, password, uid } = account;

    const [isNameEditing, setIsNameEditing] = useState(false);

    const isNameExist = Boolean(name);

    const onSaveAccountName = useCallback(
        modifiedAccountData => {
            setIsNameEditing(false);
            setAccountData(modifiedAccountData);
        },
        [setAccountData]
    );

    const onAccountNameEditingButtonClick = useCallback(() => {
        setIsNameEditing(true);
        logInfo({ message: 'account-data-component:name-editing-button:click' });
    }, []);

    const closeAccountNameEditor = () => setIsNameEditing(false);

    return (
        <div className={styles.root}>
            <div className={styles.nameButton}>
                <Button
                    onClick={onAccountNameEditingButtonClick}
                    borderType={BorderType.WITHOUT_BORDERS}
                >
                    <Text oneLine isBold>
                        {isNameExist ? name : defaultAccountName}
                    </Text>
                </Button>
            </div>

            {isNameEditing ? (
                <AccountNameEditor
                    uid={uid}
                    accountName={name}
                    onSave={onSaveAccountName}
                    onDiscard={closeAccountNameEditor}
                />
            ) : null}

            <div className={styles.caption}>
                <Text withRedFirstLetter size={TextSize.TINY}>
                    Логин:
                </Text>
            </div>
            <Text oneLine>{login}</Text>

            <div className={styles.caption}>
                <Text withRedFirstLetter size={TextSize.TINY}>
                    Пароль:
                </Text>
            </div>
            <Text oneLine>{password}</Text>

            <div className={styles.caption}>
                <Text withRedFirstLetter size={TextSize.TINY}>
                    Идентификатор:
                </Text>
            </div>
            <Text oneLine>{uid}</Text>
        </div>
    );
};
