import React from 'react';

import { Text, TextSize } from 'src/components';
import { getEnvironmentText } from 'src/utils/getEnvironmentText';
import { formatDate } from 'src/utils/date';

import styles from './AccountHeader.pcss';

export const AccountHeader = props => {
    const { account } = props;
    const { date, environment } = account;

    return (
        <div className={styles.root}>
            <div className={styles.text}>
                <Text size={TextSize.TINY}>
                    {formatDate(date)} / {getEnvironmentText(environment)}
                </Text>
            </div>
        </div>
    );
};
