import React, { useCallback, useRef } from 'react';

import { Button, Text } from 'src/components';

import styles from './AccountNameEditor.pcss';
import { defaultAccountName } from 'src/components/Account/config';
import { accountsManager } from 'src/entities/AccountsManager';
import { logInfo } from 'src/logger';

export const AccountNameEditor = props => {
    const { uid, accountName, onSave, onDiscard } = props;

    const textareaRef = useRef(null);

    const onSaveButtonClick = useCallback(async () => {
        const newAccountName = textareaRef.current.value;

        // Получении JSON данные аккаунта
        const accountEntity = accountsManager.getByUid(uid);
        const accountData = accountEntity.get();

        // Меняем данные аккаунта
        const modifiedAccountData = {
            ...accountData,
            name: newAccountName,
        };

        // Записываем измененный аккаунт
        accountsManager.add(modifiedAccountData);

        // Снова получаем аккаунт и добавляем его в закладки
        const newAccountEntity = accountsManager.getByUid(uid);
        const newAccountData = await newAccountEntity.addToBookmarks();

        onSave(newAccountData);
        logInfo({ message: 'account-name-editor:save-account-name-button:click' });
    }, [uid, onSave, textareaRef]);

    const onDiscardButtonClick = useCallback(() => {
        onDiscard();
        logInfo({ message: 'account-name-editor:discard-save-account-name-button:click' });
    }, [onDiscard]);

    return (
        <div className={styles.root}>
            <div className={styles.wrapper}>
                <textarea
                    ref={textareaRef}
                    autoFocus
                    placeholder={defaultAccountName}
                    className={styles.editor}
                >
                    {accountName}
                </textarea>
                <div className={styles.buttons}>
                    <Button onClick={onSaveButtonClick} className={styles.button}>
                        <Text withRedFirstLetter>Готово</Text>
                    </Button>
                    <Button onClick={onDiscardButtonClick} className={styles.button}>
                        <Text withRedFirstLetter>Отмена</Text>
                    </Button>
                </div>
            </div>
        </div>
    );
};
