import { getEnvironmentText } from 'src/utils/getEnvironmentText';
import { getPassportURL } from 'src/utils/urlBuilder';

export function getFormattedAccountData(account) {
    const { login, password, uid, environment, date } = account;

    const rows = [
        `${getEnvironmentText(environment)} аккаунт yawe:`,
        `Создан: ${date}`,
        `Логин: ${login}`,
        `Пароль: ${password}`,
        `Идентификатор: ${uid}`,
        '-',
        getPassportURL(account),
    ];

    return rows.join('\n');
}
