import React, { useCallback } from 'react';
import cn from 'classnames';

import styles from './AddToFavoritesButton.pcss';

import { Button, BorderType } from 'src/components/Button';
import { BookmarkIcon } from 'src/icons/BookmarkIcon';
import { logInfo } from 'src/logger';

import { accountsManager } from 'src/entities/AccountsManager';

export const AddToFavoritesButton = props => {
    const { account, setAccountData } = props;
    const { uid, inBookmarks } = account;

    const iconClassName = cn({
        [styles.icon]: inBookmarks,
    });

    const onButtonClick = useCallback(async () => {
        const modifiedAccount = await accountsManager.toggleBookmark(uid);
        logInfo({ message: 'add-to-favorites-button:click' });

        setAccountData({ ...modifiedAccount });
    }, [uid, setAccountData]);

    return (
        <div className={styles.root}>
            <Button onClick={onButtonClick} borderType={BorderType.WITHOUT_BORDERS}>
                <BookmarkIcon className={iconClassName} />
            </Button>
        </div>
    );
};
