import React from 'react';
import cn from 'classnames';

import { Spinner, Size } from 'src/components/Spinner';
import { ButtonType } from './types';

import styles from './Button.pcss';

export const Button = props => {
    const {
        onClick,
        children,
        disabled,
        className,
        autoFocus,
        borderType,
        onMouseLeave,
        isLoading = false,
        withScaling = false,
        type = ButtonType.DEFAULT,
    } = props;

    const rootClassNames = cn(styles.root, styles[type], className, {
        [styles.root_loading]: isLoading,
        [styles[`root_borderType_${borderType}`]]: borderType,
        [styles[`root_withScaling`]]: withScaling,
    });

    return (
        <button
            className={rootClassNames}
            onClick={onClick}
            autoFocus={autoFocus}
            disabled={disabled || isLoading}
            onMouseLeave={onMouseLeave}
        >
            {isLoading ? (
                <div className={styles.spinner}>
                    <Spinner size={Size.IN_BUTTON} />
                </div>
            ) : (
                children
            )}
        </button>
    );
};

export default Button;
