import React from 'react';

import { UpdateIcon } from 'src/icons';
import config from 'src/config';
import { Text } from 'src/components/Text';
import { getNewestVersionAvailable } from 'src/utils/version';

import styles from './CurrentVersion.pcss';

export const CurrentVersion = props => {
    const { actualVersion } = props;

    if (getNewestVersionAvailable(actualVersion)) {
        return (
            <div className={styles.root}>
                <UpdateIcon />
            </div>
        );
    }

    return (
        <Text withRedFirstLetter className={styles.root}>
            V{config.version}
        </Text>
    );
};

export default CurrentVersion;
