import React, { useCallback } from 'react';
import cn from 'classnames';
import { Link as ReactLink } from 'react-router-dom';

import { openLink } from 'src/utils/chrome';

import { LinkType } from './types';
import styles from './Link.pcss';

export const Link = props => {
    const {
        href,
        children,
        className,
        type = undefined,
        style = undefined,
        onClick: onClickCallback = () => {},
    } = props;

    const rootClassNames = cn(styles.root, className, {
        [styles[`root_type_${type}`]]: type,
        [styles[`root_style_${style}`]]: style,
    });

    const onClick = useCallback(() => {
        if (type === LinkType.ROUTER) {
            return;
        }

        onClickCallback();
        openLink({ href });
    }, [type, href]);

    const aProps = {
        href,
        onClick,
        className: rootClassNames,
    };

    if (type === LinkType.ROUTER) {
        const reactLinkProps = {
            ...aProps,
            href: undefined,
            to: aProps.href,
        };

        return <ReactLink {...reactLinkProps}>{children}</ReactLink>;
    }

    return <a {...aProps}>{children}</a>;
};

export default Link;
