import React, { useCallback, useEffect } from 'react';
import cn from 'classnames';

import { Text } from 'src/components/Text';
import { Button } from 'src/components/Button';
import { modal } from 'src/entities/Modal';
import { logInfo } from 'src/logger';

import { useReactivity } from './hook';

import styles from './Modal.pcss';

export const Modal = () => {
    useReactivity();

    const {
        isVisible,
        type,
        message,
        retryButtonText,
        closeButtonText,
        retryCallback,
    } = modal.getData();

    useEffect(() => {}, []);

    const rootClassName = cn(styles.root, {
        [styles['root_visible']]: isVisible,
    });

    const contentClassName = cn(styles.content, {
        [styles[`content_type_${type}`]]: type,
    });

    const onCloseButtonClick = useCallback(() => modal.hide(), []);

    const onRetryButtonClick = useCallback(() => {
        modal.hide();
        retryCallback();
        logInfo({ message: 'modal-component:retry-button:click' });
    }, [retryCallback]);

    return (
        <div className={rootClassName}>
            <div className={contentClassName}>
                <div className={styles.textWrapper}>
                    <Text>{message || 'Простите, что-то пошло не так'}</Text>
                </div>

                <Button className={styles.button} onClick={onCloseButtonClick}>
                    <Text withRedFirstLetter>{closeButtonText || 'Понятно'}</Text>
                </Button>

                {retryButtonText && retryCallback && (
                    <Button className={styles.button} onClick={onRetryButtonClick}>
                        <Text withRedFirstLetter>{retryButtonText}</Text>
                    </Button>
                )}
            </div>
        </div>
    );
};

export default Modal;
