import React, { useCallback, useEffect } from 'react';

import { getActualVersion } from 'src/dataProvider/getActualVersion';
import { Text } from 'src/components/Text';
import { Link } from 'src/components/Link';
import { URL } from 'src/constants/urls';
import { saveActualVersion, getNewestVersionAvailable } from 'src/utils/version';

import styles from './NewVersion.pcss';

export const NewVersion = props => {
    const { actualVersion, setActualVersion } = props;
    const newestVersionAvailable = getNewestVersionAvailable(actualVersion);

    const onSuccessCallback = useCallback(xhr => {
        const { version } = JSON.parse(xhr.target.response);

        saveActualVersion(version);
        setActualVersion(version);
    }, []);

    useEffect(() => {
        getActualVersion(onSuccessCallback);
    }, []);

    if (!newestVersionAvailable) {
        return null;
    }

    const message = `V${actualVersion}`;

    return (
        <Link className={styles.root} href={URL.GITHUB_PAGES}>
            <Text withRedFirstLetter>Обновиться до </Text>
            <Text withRedFirstLetter>{message}</Text>
        </Link>
    );
};

export default NewVersion;
