import React, { useState } from 'react';

import styles from 'src/components/Root/Root.pcss';
import { LeftMenu, Logo, Menu } from 'src/components';
import config from 'src/config';

export function PageLayout(props) {
    const [actualVersion, setActualVersion] = useState(config.version);

    const leftMenuProps = {
        actualVersion,
        setActualVersion,
    };

    return (
        <div className={styles.root}>
            <LeftMenu {...leftMenuProps} />
            <Menu />
            <Logo />
            {props.children}
        </div>
    );
}
