import React from 'react';
import { Redirect } from 'react-router-dom';

import { oAuthToken } from 'src/entities/OAuthToken';
import { yandexTeamLogin } from 'src/entities/YandexTeamLogin';
import { userConsumer } from 'src/entities/UserConsumer';

import { Path } from 'src/types/navigation';

export function Redirects() {
    if (!oAuthToken.get() || !yandexTeamLogin.get() || !userConsumer.get()) {
        return <Redirect to={Path.OAuth} />;
    }

    return null;
}
