import React from 'react';
import { MemoryRouter, Switch, Route } from 'react-router';

import { Path } from 'src/types/navigation';
import { Main } from 'src/pages/Main';
import { OAuth } from 'src/pages/OAuth';
import { Accounts } from 'src/pages/Accounts';
import { Modal } from 'src/components/Modal';

import { PageLayout } from 'src/components/PageLayout';

export const Root = () => {
    return (
        <MemoryRouter>
            <Modal />
            <Switch>
                <Route exact path={Path.Root}>
                    <PageLayout>
                        <Main />
                    </PageLayout>
                </Route>

                <Route exact path={Path.OAuth}>
                    <PageLayout>
                        <OAuth />
                    </PageLayout>
                </Route>

                <Route exact path={Path.Accounts}>
                    <Accounts />
                </Route>
            </Switch>
        </MemoryRouter>
    );
};

export default Root;
