import React, { useCallback, useState } from 'react';
import { Input } from 'src/components';
import { yandexTeamLogin } from 'src/entities/YandexTeamLogin';

import { logInfo } from 'src/logger';
import { accountLogin } from 'src/entities/AccountLogin';
import { accountPassword } from 'src/entities/AccountPassword';

import styles from './Settings.pcss';

export const Settings = () => {
    const [customAccountLogin, setCustomAccountLogin] = useState(yandexTeamLogin.get());
    const [customAccountPassword, setCustomAccountPassword] = useState(accountPassword.get());

    const onLoginInputChange = useCallback(
        event => {
            const { value } = event.target;

            accountLogin.set(value);
            setCustomAccountLogin(value);
        },
        [setCustomAccountLogin, accountLogin.set]
    );

    const onLoginInputFocus = useCallback(
        () => logInfo({ message: 'account-settings:login-input:focus' }),
        []
    );

    const onPasswordInputChange = useCallback(
        event => {
            const { value } = event.target;

            accountPassword.set(value);
            setCustomAccountPassword(value);
        },
        [setCustomAccountPassword, accountLogin.set]
    );

    const onPasswordInputFocus = useCallback(
        () => logInfo({ message: 'account-settings:password-input:focus' }),
        []
    );

    const loginInputProps = {
        initialValue: customAccountLogin,
        onChange: onLoginInputChange,
        onFocus: onLoginInputFocus,
        className: styles.input,
        maxLength: accountLogin.getMaxLoginLength(),
        label: 'Логин',
    };

    const passwordInputProps = {
        initialValue: customAccountPassword,
        onChange: onPasswordInputChange,
        onFocus: onPasswordInputFocus,
        className: styles.input,
        maxLength: accountPassword.getMaxPasswordLength(),
        label: 'Пароль',
    };

    return (
        <div className={styles.root}>
            <Input {...loginInputProps} />
            <Input {...passwordInputProps} />
        </div>
    );
};
