import React, { useCallback, useState } from 'react';

import { ShareIcon, CheckIcon } from 'src/icons';
import { setClipboardValue } from 'src/utils/clipboard';
import { Button, BorderType } from 'src/components/Button';
import { Time } from 'src/types/time';

import styles from './ShareButton.pcss';
import { logInfo } from 'src/logger';

export const ShareButton = props => {
    const { data } = props;

    const [isDone, setIdDone] = useState(false);

    const onButtonClick = useCallback(async () => {
        await setClipboardValue(data);
        logInfo({ message: 'share-button:click' });

        // Пользователь может нажать кнопку сразу еще раз. В этом случае не надо запускать таймер повторно.
        if (!isDone) {
            setTimeout(() => setIdDone(false), Time.SECOND);
        }

        setIdDone(true);
    }, [data, isDone, setIdDone]);

    const icon = isDone ? (
        <CheckIcon className={styles.checkIcon} />
    ) : (
        <ShareIcon className={styles.shareIcon} />
    );

    return (
        <Button withScaling onClick={onButtonClick} borderType={BorderType.WITHOUT_BORDERS}>
            <div className={styles.root}>{icon}</div>
        </Button>
    );
};
