import React from 'react';
import cn from 'classnames';

import { TextSize, TextTheme } from './types';

import styles from './Text.pcss';

export const Text = props => {
    const {
        children,
        size = TextSize.MEDIUM,
        withRedFirstLetter,
        className,
        isBold,
        color,
        withAnimation,
        theme,
        onClick,
        oneLine,
        contenteditable,
    } = props;

    const rootClassNames = cn(styles.root, styles[size], styles[color], className, {
        [styles.bold]: isBold,
        [styles.root_oneLine]: oneLine,
        [styles.root_withAnimation]: withAnimation,
        [styles[`root_theme_${theme}`]]: theme,
    });

    if (withRedFirstLetter) {
        const firstLetter = children[0];
        const otherText = children.slice(1);

        return (
            <span title={children} className={rootClassNames} onClick={onClick}>
                <span className={styles.redFirstLetter}>{firstLetter}</span>
                <span>{otherText}</span>
            </span>
        );
    }

    return (
        <span contenteditable={contenteditable} title={children} className={rootClassNames}>
            {children}
        </span>
    );
};

export default Text;
