import React, { useState } from 'react';
import cn from 'classnames';

import { VersionStatusState } from './types';

import styles from './VersionStatus.pcss';

export const VersionStatus = () => {
    const [status, setStatus] = useState(VersionStatusState.LOADING);

    let content = '🤔';
    if (status === VersionStatusState.ACTUAL) {
        content = '✅';
    } else if (status === VersionStatusState.OUTDATED) {
        content = '⚠️';
    }

    return <div className={cn(styles.root, styles[status])}>{content}</div>;
};

export default VersionStatus;
