import { getPassportDomain } from 'src/utils/urlBuilder';

import { Header, RequestMethod } from './types';

export async function authorizeUser(account) {
    const { environment, login, password } = account;

    const passportDomain = getPassportDomain(environment);

    const headers = {
        [Header.CONTENT_TYPE]: 'application/x-www-form-urlencoded',
    };

    const body = `login=${login}&passwd=${password}`;

    const response = await fetch(passportDomain, {
        body,
        headers,
        method: RequestMethod.POST,
    });

    const { url = '' } = response || {};
    const isSuccessful = url.includes('profile');

    return {
        url,
        isSuccessful,
    };
}
