import { URL } from 'src/constants/urls';
import { Header, RequestMethod } from 'src/dataProvider/types';

import { oAuthToken } from 'src/entities/OAuthToken';
import { yandexTeamLogin } from 'src/entities/YandexTeamLogin';

const CONSUMER_PREFIX = 'yaweuser_';
const SHORT_CONSUMER_PREFIX = 'yaweu_';

function getConsumer({ yandexTeamLogin }) {
    const consumer = `${CONSUMER_PREFIX}${yandexTeamLogin}`;

    if (consumer.length > 21) {
        return `${SHORT_CONSUMER_PREFIX}${yandexTeamLogin}`.slice(0, 21);
    }

    return consumer;
}

export const CreateConsumerStatus = {
    OK: 'ok',
};

export const CreateConsumerError = {
    ALREADY_EXIST: 'tus_consumer.already_exist',
};

export async function createConsumer() {
    const userConsumer = getConsumer({ yandexTeamLogin: yandexTeamLogin.get() });

    const requestURL = `${URL.CREATE_CONSUMER}?tus_consumer=${userConsumer}`;

    const headers = {
        [Header.AUTHORIZATION]: `OAuth ${oAuthToken.get()}`,
    };

    const response = await fetch(requestURL, {
        headers,
        method: RequestMethod.POST,
    });

    const responseText = await response.text();

    try {
        const { status, error } = JSON.parse(responseText);
        return { userConsumer, status, error };
    } catch (error) {
        console.error('createConsumer response: ', responseText);
        console.error('createConsumer error: ', error);
    }
}
