import { URL } from 'src/constants/urls';
import { Header, RequestMethod } from 'src/dataProvider/types';

import { oAuthToken } from 'src/entities/OAuthToken';
import { userConsumer } from 'src/entities/UserConsumer';

export async function getAccount(params) {
    const consumer = userConsumer.get();

    const { uid, environment } = params;

    const requestURL = `${URL.GET_ACCOUNT}?tus_consumer=${consumer}&uid=${uid}&env=${environment}`;

    const headers = {
        [Header.AUTHORIZATION]: `OAuth ${oAuthToken.get()}`,
    };

    const response = await fetch(requestURL, { headers, method: RequestMethod.GET });

    const responseText = await response.text();

    try {
        const { status, account } = JSON.parse(responseText);

        const isSuccess = status === 'ok';

        return { isSuccess, account: { ...account } };
    } catch (error) {
        console.error('saveAccount response: ', responseText);
        console.error('saveAccount error: ', error);
    }
}
