import { URL } from 'src/constants/urls';
import { Header, RequestMethod } from 'src/dataProvider/types';
import { getSavedUserConsumer } from 'src/utils/userConsumer';
import { getSavedUserOAuthToken } from 'src/utils/oAuth';

export async function getAccounts({ onSuccessCallback }) {
    const oAuthToken = getSavedUserOAuthToken();
    const userConsumer = getSavedUserConsumer();

    const requestURL = `${URL.GET_ACCOUNTS}?tus_consumer=${userConsumer}&env=prod`;

    const headers = {
        [Header.AUTHORIZATION]: `OAuth ${oAuthToken}`,
    };

    const response = await fetch(requestURL, {
        headers,
        method: RequestMethod.GET,
    });

    const responseText = await response.text();

    try {
        const response = { userConsumer, ...JSON.parse(responseText) };
        onSuccessCallback(response);
        return response;
    } catch (error) {
        console.error('createConsumer response: ', responseText);
        console.error('createConsumer error: ', error);
    }
}
